#
# This is an implementation of part of the DES specification.  According
# to the code this is ported from, this code does NOT enable 2-way
# encryption and is, hence, not a cypher and does not appear to come
# under any export restrictions on such.
#
package Authen::NTLM::DES;

use vars qw($VERSION @ISA @EXPORT);
require Exporter;

$VERSION = "1.02";
@ISA = qw(Exporter);
@EXPORT = qw(E_P16 E_P24);

my ($loop, $loop2);
$loop = 0;
$loop2 = 0;

my $perm1 = [57, 49, 41, 33, 25, 17, 9,
             1, 58, 50, 42, 34, 26, 18,
	     10, 2, 59, 51, 43, 35, 27,
	     19, 11, 3, 60, 52, 44, 36,
	     63, 55, 47, 39, 31, 23, 15,
	     7, 62, 54, 46, 38, 30, 22,
	     14, 6, 61, 53, 45, 37, 29,
	     21, 13, 5, 28, 20, 12, 4];
my $perm2 = [14, 17, 11, 24, 1, 5,
             3, 28, 15, 6, 21, 10,
	     23, 19, 12, 4, 26, 8,
	     16, 7, 27, 20, 13, 2,
	     41, 52, 31, 37, 47, 55,
	     30, 40, 51, 45, 33, 48,
	     44, 49, 39, 56, 34, 53,
	     46, 42, 50, 36, 29, 32];
my $perm3 = [58, 50, 42, 34, 26, 18, 10, 2,
             60, 52, 44, 36, 28, 20, 12, 4,
	     62, 54, 46, 38, 30, 22, 14, 6,
	     64, 56, 48, 40, 32, 24, 16, 8,
	     57, 49, 41, 33, 25, 17, 9, 1,
	     59, 51, 43, 35, 27, 19, 11, 3,
	     61, 53, 45, 37, 29, 21, 13, 5,
	     63, 55, 47, 39, 31, 23, 15, 7];
my $perm4 = [32, 1, 2, 3, 4, 5,
             4, 5, 6, 7, 8, 9,
	     8, 9, 10, 11, 12, 13,
	     12, 13, 14, 15, 16, 17,
	     16, 17, 18, 19, 20, 21,
	     20, 21, 22, 23, 24, 25,
	     24, 25, 26, 27, 28, 29,
	     28, 29, 30, 31, 32, 1];
my $perm5 = [16, 7, 20, 21, 29, 12, 28, 17,
             1, 15, 23, 26, 5, 18, 31, 10,
	     2, 8, 24, 14, 32, 27, 3, 9,
	     19, 13, 30, 6, 22, 11, 4, 25];
my $perm6 = [40, 8, 48, 16, 56, 24, 64, 32,
             39, 7, 47, 15, 55, 23, 63, 31,
	     38, 6, 46, 14, 54, 22, 62, 30,
	     37, 5, 45, 13, 53, 21, 61, 29,
	     36, 4, 44, 12, 52, 20, 60, 28,
	     35, 3, 43, 11, 51, 19, 59, 27,
	     34, 2, 42, 10, 50, 18, 58, 26,
	     33, 1, 41,  9, 49, 17, 57, 25];
my $sc = [1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1];
my $sbox = [
[
[14, 4, 13, 1, 2, 15, 11, 8, 3, 10, 6, 12, 5, 9, 0, 7],
[0, 15, 7, 4, 14, 2, 13, 1, 10, 6, 12, 11, 9, 5, 3, 8],
[4, 1, 14, 8, 13, 6, 2, 11, 15, 12, 9, 7, 3, 10, 5, 0],
[15, 12, 8, 2, 4, 9, 1, 7, 5, 11, 3, 14, 10, 0, 6, 13]
],
[
[15, 1, 8, 14, 6, 11, 3, 4, 9, 7, 2, 13, 12, 0, 5, 10],
[3, 13, 4, 7, 15, 2, 8, 14, 12, 0, 1, 10, 6, 9, 11, 5],
[0, 14, 7, 11, 10, 4, 13, 1, 5, 8, 12, 6, 9, 3, 2, 15],
[13, 8, 10, 1, 3, 15, 4, 2, 11, 6, 7, 12, 0, 5, 14, 9]
],
[
[10, 0, 9, 14, 6, 3, 15, 5, 1, 13, 12, 7, 11, 4, 2, 8],
[13, 7, 0, 9, 3, 4, 6, 10, 2, 8, 5, 14, 12, 11, 15, 1],
[13, 6, 4, 9, 8, 15, 3, 0, 11, 1, 2, 12, 5, 10, 14, 7],
[1, 10, 13, 0, 6, 9, 8, 7, 4, 15, 14, 3, 11, 5, 2, 12]
],
[
[7, 13, 14, 3, 0, 6, 9, 10, 1, 2, 8, 5, 11, 12, 4, 15],
[13, 8, 11, 5, 6, 15, 0, 3, 4, 7, 2, 12, 1, 10, 14, 9],
[10, 6, 9, 0, 12, 11, 7, 13, 15, 1, 3, 14, 5, 2, 8, 4],
[3, 15, 0, 6, 10, 1, 13, 8, 9, 4, 5, 11, 12, 7, 2, 14]
],
[
[2,12,4,1,7,10,11,6,8,5,3,15,13,0,14,9],
[14,11,2,12,4,7,13,1,5,0,15,10,3,9,8,6],
[4,2,1,11,10,13,7,8,15,9,12,5,6,3,0,14],
[11,8,12,7,1,14,2,13,6,15,0,9,10,4,5,3]
],
[
[12,1,10,15,9,2,6,8,0,13,3,4,14,7,5,11],
[10,15,4,2,7,12,9,5,6,1,13,14,0,11,3,8],
[9,14,15,5,2,8,12,3,7,0,4,10,1,13,11,6],
[4,3,2,12,9,5,15,10,11,14,1,7,6,0,8,13]
],
[
[4,11,2,14,15,0,8,13,3,12,9,7,5,10,6,1],
[13,0,11,7,4,9,1,10,14,3,5,12,2,15,8,6],
[1,4,11,13,12,3,7,14,10,15,6,8,0,5,9,2],
[6,11,13,8,1,4,10,7,9,5,0,15,14,2,3,12]
],
[
[13,2,8,4,6,15,11,1,10,9,3,14,5,0,12,7],
[1,15,13,8,10,3,7,4,12,5,6,11,0,14,9,2],
[7,11,4,1,9,12,14,2,0,6,10,13,15,3,5,8],
[2,1,14,7,4,10,8,13,15,12,9,0,3,5,6,11]
]
];

sub E_P16
{
  my ($p14) = @_;
  my $sp8 = [0x4b, 0x47, 0x53, 0x21, 0x40, 0x23, 0x24, 0x25];

  my $p7 = substr($p14, 0, 7);
  my $p16 = smbhash($sp8, $p7);
  $p7 = substr($p14, 7, 7);
  $p16 .= smbhash($sp8, $p7);
  return $p16;
}

sub E_P24
{
  my ($p21, $c8_str) = @_;
  my @c8 = map {ord($_)} split(//, $c8_str);
  my $p24 = smbhash(\@c8, substr($p21, 0, 7));
  $p24 .= smbhash(\@c8, substr($p21, 7, 7));
  $p24 .= smbhash(\@c8, substr($p21, 14, 7));
}

sub permute
{
  my ($out, $in, $p, $n) = @_;
  my $i;

  foreach $i (0..($n-1))
  {
    $out->[$i] = $in->[$p->[$i]-1];
  }
}

sub lshift
{
  my ($d, $count, $n) = @_;
  my (@out, $i);

  foreach $i (0..($n-1))
  {
    $out[$i] = $d->[($i+$count)%$n];
  }
  foreach $i (0..($n-1))
  {
    $d->[$i] = $out[$i];
  }
}

sub xor
{
  my ($out, $in1, $in2, $n) = @_;
  my $i;

  foreach $i (0..($n-1))
  {
    $out->[$i] = $in1->[$i]^$in2->[$i];
  }
}

sub dohash
{
  my ($out, $in, $key) = @_;
  my ($i, $j, $k, @pk1, @c, @d, @cd,
      @ki, @pd1, @l, @r, @rl);

  &permute(\@pk1, $key, $perm1, 56);

  foreach $i (0..27)
  {
    $c[$i] = $pk1[$i];
    $d[$i] = $pk1[$i+28];
  }
  foreach $i (0..15)
  {
    my @array;
    &lshift(\@c, $sc->[$i], 28);
    &lshift(\@d, $sc->[$i], 28);
    @cd = (@c, @d);
    &permute(\@array, \@cd, $perm2, 48);
    $ki[$i] = \@array;
  }
  &permute(\@pd1, $in, $perm3, 64);

  foreach $j (0..31)
  {
    $l[$j] = $pd1[$j];
    $r[$j] = $pd1[$j+32];
  }

  foreach $i (0..15)
  {
    local (@er, @erk, @b, @cb, @pcb, @r2);
    permute(\@er, \@r, $perm4, 48);
    &xor(\@erk, \@er, $ki[$i], 48);
    foreach $j (0..7)
    {
      foreach $k (0..5)
      {
	$b[$j][$k] = $erk[$j*6+$k];
      }
    }
    foreach $j (0..7)
    {
      local ($m, $n);
      $m = ($b[$j][0]<<1) | $b[$j][5];
      $n = ($b[$j][1]<<3) | ($b[$j][2]<<2) | ($b[$j][3]<<1) | $b[$j][4];
      foreach $k (0..3)
      {
	$b[$j][$k] = ($sbox->[$j][$m][$n] & (1<<(3-$k)))? 1: 0;
      }
    }
    foreach $j (0..7)
    {
      foreach $k (0..3)
      {
	$cb[$j*4+$k] = $b[$j][$k];
      }
    }
    &permute(\@pcb, \@cb, $perm5, 32);
    &xor(\@r2, \@l, \@pcb, 32);
    foreach $j (0..31)
    {
      $l[$j] = $r[$j];
      $r[$j] = $r2[$j];
    }
  }
  @rl = (@r, @l);
  &permute($out, \@rl, $perm6, 64);
}

sub str_to_key
{
  my ($str) = @_;
  my $i;
  my @key;
  my $out;
  my @str = map {ord($_)} split(//, $str);
  $key[0] = $str[0]>>1;
  $key[1] = (($str[0]&0x01)<<6) | ($str[1]>>2);
  $key[2] = (($str[1]&0x03)<<5) | ($str[2]>>3);
  $key[3] = (($str[2]&0x07)<<4) | ($str[3]>>4);
  $key[4] = (($str[3]&0x0f)<<3) | ($str[4]>>5);
  $key[5] = (($str[4]&0x1f)<<2) | ($str[5]>>6);
  $key[6] = (($str[5]&0x3f)<<1) | ($str[6]>>7);
  $key[7] = $str[6]&0x7f;
  foreach $i (0..7)
  {
    $key[$i] = 0xff&($key[$i]<<1);
  }
  return \@key;
}

sub smbhash
{
  my ($in, $key) = @_;

  my $key2 = &str_to_key($key);
  my ($i, $div, $mod, @in, @outb, @inb, @keyb, @out);
  foreach $i (0..63)
  {
    $div = int($i/8); $mod = $i%8;
    $inb[$i] = ($in->[$div] & (1<<(7-($mod))))? 1: 0;
    $keyb[$i] = ($key2->[$div] & (1<<(7-($mod))))? 1: 0;
    $outb[$i] = 0;
  }
  &dohash(\@outb, \@inb, \@keyb);
  foreach $i (0..7)
  {
    $out[$i] = 0;
  }
  foreach $i (0..63)
  {
    $out[int($i/8)] |= (1<<(7-($i%8))) if ($outb[$i]);
  }
  my $out = pack("C8", @out);
  return $out;
}

1;
